local style = ToEnumShortString(GAMESTATE:GetCurrentStyle():GetStyleType());

--Footer
local bgcolor = color("#000000cc");
local t = Def.ActorFrame{

	--Left side
	Def.Quad{
		InitCommand=cmd(setsize,SCREEN_WIDTH/3-50,50;diffuse,bgcolor;xy,SCREEN_WIDTH/2-50,SCREEN_BOTTOM-50;horizalign,right)
	};
	triangleGen(SCREEN_WIDTH/2-50,SCREEN_BOTTOM-75,bgcolor);
	--triangleGen(SCREEN_WIDTH/2-SCREEN_WIDTH/3-50,SCREEN_BOTTOM-75,Color("White"););
	
	Def.ActorMultiVertex{
		InitCommand=function(self)
			self:xy(SCREEN_WIDTH/2-SCREEN_WIDTH/3-50,SCREEN_BOTTOM-75);
			self:SetDrawState{Mode="DrawMode_Triangles"}
            self:SetVertices({
                {{50, 50, 0}, bgcolor},
        		{{0, 50, 0}, bgcolor},
				{{50, 0, 0}, bgcolor}
            });
        end;
	};
	
	--Right side
	Def.Quad{
		InitCommand=cmd(setsize,SCREEN_WIDTH/3-50,50;diffuse,bgcolor;xy,SCREEN_WIDTH/2+50,SCREEN_BOTTOM-50;horizalign,left)
	};
	Def.ActorMultiVertex{
		InitCommand=function(self)
			local clr = Color("White");
			self:xy(SCREEN_WIDTH/2,SCREEN_BOTTOM-75);
			self:SetDrawState{Mode="DrawMode_Triangles"}
            self:SetVertices({
                {{0, 0, 0}, bgcolor},
        		{{50, 50, 0}, bgcolor},
				{{50, 0, 0}, bgcolor}
            });
        end;
	};
	Def.ActorMultiVertex{
		InitCommand=function(self)
			self:xy(SCREEN_WIDTH/2+SCREEN_WIDTH/3,SCREEN_BOTTOM-75);
			self:SetDrawState{Mode="DrawMode_Triangles"}
            self:SetVertices({
                {{0, 0, 0}, bgcolor},
        		{{0, 50, 0}, bgcolor},
				{{50, 50, 0}, bgcolor}
            });
        end;
	};
};


if style == "OnePlayerOneSide" or style == "OnePlayerTwoSides" then
	local player = GAMESTATE:GetMasterPlayerNumber()
	t[#t+1] = Def.ActorFrame{
		LoadFont("_museca normal 20px")..{
			Text="SCORE";
			InitCommand=cmd(xy,SCREEN_WIDTH/2+20,SCREEN_BOTTOM-58;horizalign,left;vertalign,bottom);
		};
		LoadFont("ScreenGameplay Scoreboard")..{
			Text="000000000";
			InitCommand=cmd(xy,SCREEN_WIDTH/2+100,SCREEN_BOTTOM-52;horizalign,left;);
			LifeChangedMessageCommand=function(self, params)
				if params.Player == player then
					local score = STATSMAN:GetCurStageStats():GetPlayerStageStats(player):GetScore();
					self:settextf("%09.0f", score);
				end;
			end;
		};
		LoadFont("Common Normal")..{
			InitCommand=cmd(settext,GAMESTATE:GetCurrentSong():GetDisplayMainTitle();xy,SCREEN_WIDTH/2-SCREEN_WIDTH/3+20,SCREEN_BOTTOM-55;horizalign,left;vertalign,bottom;maxwidth,SCREEN_WIDTH/3-50);
		};
		LoadFont("Common Normal")..{
			InitCommand=cmd(settext,GAMESTATE:GetCurrentSong():GetDisplayArtist();xy,SCREEN_WIDTH/2-SCREEN_WIDTH/3+20,SCREEN_BOTTOM-45;horizalign,left;vertalign,top;maxwidth,SCREEN_WIDTH/3-75);
		};
		
		-- Master player level display
		parallelogramGen(120,20,_G.diffColors[ToEnumShortString(GAMESTATE:GetCurrentSteps(player):GetDifficulty())])..{
			InitCommand=cmd(xy,SCREEN_WIDTH/2-120,SCREEN_BOTTOM-15;diffusealpha,.55);
		};
		LoadFont("_museca normal 20px")..{
			Text="Level "..GAMESTATE:GetCurrentSteps(player):GetMeter();
			InitCommand=cmd(xy,SCREEN_WIDTH/2-120,SCREEN_BOTTOM-16;);
		};
		
		-- Master player BPM display
		parallelogramGen(120,20,color("#555555cc"))..{
			InitCommand=cmd(xy,SCREEN_WIDTH/2-240,SCREEN_BOTTOM-15;);
		};
		LoadActor(THEME:GetPathG("ScreenGameplay", "BPMDisplay"), player)..{
			InitCommand=cmd(xy,SCREEN_WIDTH/2-240,SCREEN_BOTTOM-17;);
		};
		
		LoadFont("_museca normal 20px")..{
			Text=GAMESTATE:GetPlayerState(player):GetPlayerOptionsString("ModsLevel_Current");
			InitCommand=cmd(xy,SCREEN_WIDTH/2+50,SCREEN_BOTTOM-15;horizalign,left;diffuse,Color("White");maxwidth,SCREEN_WIDTH/3);
		};
		
	};
	if GAMESTATE:GetCurrentSong():HasJacket() then
		t[#t+1] = LoadActor(GAMESTATE:GetCurrentSong():GetJacketPath())..{
			InitCommand=cmd(zoomtowidth,70;zoomtoheight,70;xy,SCREEN_WIDTH/2-SCREEN_WIDTH/3-20,SCREEN_BOTTOM-50);
		
		};
	end;
end;

if style == "TwoPlayersTwoSides" then
	t[#t+1] = Def.ActorFrame{
		LoadFont("_museca normal 20px")..{
			Text="SCORE";
			InitCommand=cmd(xy,SCREEN_WIDTH/2+20,SCREEN_BOTTOM-58;horizalign,left;vertalign,bottom);
		};
		
		LoadFont("_museca normal 20px")..{
			Text="SCORE";
			InitCommand=cmd(xy,SCREEN_WIDTH/2-20,SCREEN_BOTTOM-58;horizalign,right;vertalign,bottom);
		};
		
		LoadFont("ScreenGameplay Scoreboard")..{
			Text="000000000";
			InitCommand=cmd(xy,SCREEN_WIDTH/2-100,SCREEN_BOTTOM-52;horizalign,right;);
			LifeChangedMessageCommand=function(self, params)
				if params.Player == PLAYER_1 then
					local score = STATSMAN:GetCurStageStats():GetPlayerStageStats(PLAYER_1):GetScore();
					self:settextf("%09.0f", score);
				end;
			end;
		};
		
		LoadFont("ScreenGameplay Scoreboard")..{
			Text="000000000";
			InitCommand=cmd(xy,SCREEN_WIDTH/2+100,SCREEN_BOTTOM-52;horizalign,left;);
			LifeChangedMessageCommand=function(self, params)
				if params.Player == PLAYER_2 then
					local score = STATSMAN:GetCurStageStats():GetPlayerStageStats(PLAYER_2):GetScore();
					self:settextf("%09.0f", score);
				end;
			end;
		};
		
		-- Player 1 level display
		parallelogramGen(120,20,_G.diffColors[ToEnumShortString(GAMESTATE:GetCurrentSteps(PLAYER_1):GetDifficulty())])..{
			InitCommand=cmd(xy,SCREEN_WIDTH/2-120,SCREEN_BOTTOM-15;diffusealpha,.6);
		};
		
		LoadFont("_museca normal 20px")..{
			Text="Level "..GAMESTATE:GetCurrentSteps(PLAYER_1):GetMeter();
			InitCommand=cmd(xy,SCREEN_WIDTH/2-120,SCREEN_BOTTOM-16;);
		};
		
		-- Player 1 BPM display
		parallelogramGen(120,20,color("#555555cc"))..{
			InitCommand=cmd(xy,SCREEN_WIDTH/2-240,SCREEN_BOTTOM-15;);
		};
		
		LoadActor(THEME:GetPathG("ScreenGameplay", "BPMDisplay"), PLAYER_1)..{
			InitCommand=cmd(xy,SCREEN_WIDTH/2-240,SCREEN_BOTTOM-17;);
		};
		
		-- Player 2 level display
		parallelogramGen(120,20,_G.diffColors[ToEnumShortString(GAMESTATE:GetCurrentSteps(PLAYER_2):GetDifficulty())])..{
			InitCommand=cmd(rotationx,180;xy,SCREEN_WIDTH/2+120,SCREEN_BOTTOM-15;diffusealpha,.6);
		};
		
		LoadFont("_museca normal 20px")..{
			Text="Level "..GAMESTATE:GetCurrentSteps(PLAYER_2):GetMeter();
			InitCommand=cmd(xy,SCREEN_WIDTH/2+120,SCREEN_BOTTOM-16;);
		};
		
		-- Player 2 BPM display
		parallelogramGen(120,20,color("#555555cc"))..{
			InitCommand=cmd(rotationx,180;xy,SCREEN_WIDTH/2+240,SCREEN_BOTTOM-15;);
		};
		
		LoadActor(THEME:GetPathG("ScreenGameplay", "BPMDisplay"), PLAYER_2)..{
			InitCommand=cmd(xy,SCREEN_WIDTH/2+240,SCREEN_BOTTOM-17;);
		};
	
	}
end

--Header
t[#t+1] = Def.ActorFrame{
	InitCommand=cmd(xy,SCREEN_CENTER_X,SCREEN_TOP+35);
	Def.Quad{
		InitCommand=cmd(setsize,60,60;rotationz,45;diffuse,bgcolor);
	};
	LoadFont("_museca normal 20px")..{
		Text="STAGE";
		InitCommand=cmd(addy,-25;zoom,.75);
	};
	LoadFont("ScreenGameplay Scoreboard")..{
		InitCommand=function(self)
			if _G.CurrentFakeCourse then
				self:settext(_G.StageIndex);
			else
				--infinity symbol
				self:settext("i");
			end;
		end;
	};
};

--Lifebars. Should probably be moved
for player in ivalues(GAMESTATE:GetEnabledPlayers()) do
	t[#t+1] = Def.ActorFrame{
		InitCommand=cmd(y,35;diffuse,Color("Black"));
		OnCommand=function(self)
			if player == PLAYER_1 then
				self:x(SCREEN_WIDTH/4);
			else
				self:x(SCREEN_WIDTH*.75);
			end;
		end;
		rectGen(SCREEN_WIDTH*.405,30,3,color("0,0,0,0"))..{};
	}
end
t[#t+1] = Def.ActorFrame{


	Def.Quad{
		Name="P1Box";
		InitCommand=cmd(setsize,50,20;horizalign,left;vertalign,bottom;xy,SCREEN_WIDTH/4-SCREEN_WIDTH*.405/2-3/2,20;diffuse,Color("Black"));
	};
	LoadFont("Museca")..{
		Name="P1Name";
		OnCommand=function(self)
			local profile = PROFILEMAN:GetProfile(PLAYER_1);
			local name = profile:GetDisplayName();
			if GAMESTATE:IsHumanPlayer(PLAYER_1) == true then
				if name=="" then
					self:settext("Player 1");
				else
					self:settext( name );
				end
			end	
		end;
		InitCommand=cmd(horizalign,left;vertalign,bottom;xy,SCREEN_WIDTH/4-SCREEN_WIDTH*.405/2,18);
	};
	
	--Retard code, should only load if P2 is present.
	LoadFont("Museca")..{
		Name="P2Name";
		OnCommand=function(self)
			local profile = PROFILEMAN:GetProfile(PLAYER_2);
			local name = profile:GetDisplayName();
			if GAMESTATE:IsHumanPlayer(PLAYER_2) == true then
				if name=="" then
					self:settext("Player 2");
				else
					self:settext( name );
				end
			end	
		end;
		InitCommand=cmd(horizalign,right;vertalign,bottom;xy,SCREEN_WIDTH*.75+SCREEN_WIDTH*.405/2,18);
	};
};


return t;
